CREATE TABLE [dbo].[DIM_ICON_FLAG_FACILITY_ETL](
	[ICON_FLAG_ID] [int] NOT NULL,
	[FACILITY_UID] [nvarchar](250) NULL,
	[ORDER_INDEX] [int] NOT NULL,
	[ACTIVE] [bit] NOT NULL,
	[PATIENT_OR_ROOMBED] [char](1) NOT NULL,
	[ICON_NAME] [nvarchar](150) NULL,
	[DESCRIPTION] [nvarchar](max) NULL,
	[COMMENT] [nvarchar](150) NULL,
	[MOUSE_OVER_TEXT] [nvarchar](150) NULL,
	[ENTERED_BY] [nvarchar](50) NULL,
	[ENTERED_DATE] [datetime] NULL,
	[LAST_EDIT_BY] [nvarchar](50) NULL,
	[LAST_EDIT_DATE] [datetime] NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Update icon flag facility table used by reports incremental job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIM_ICON_FLAG_FACILITY_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_FACILITY_UID] ON [dbo].[DIM_ICON_FLAG_FACILITY_ETL] 
(
	[FACILITY_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_ICON_FLAG_ID] ON [dbo].[DIM_ICON_FLAG_FACILITY_ETL] 
(
	[ICON_FLAG_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[DIM_ICON_FLAG_FACILITY_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

